/***************************************************************************
                          dcgui.h  -  description
                             -------------------
    begin                : Mon Okt  1 19:59:45 CEST 2001
    copyright            : (C) 2001-2005 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCGUI_H
#define DCGUI_H

// include files for QT
#include <qapplication.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qworkspace.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qpopupmenu.h>
#include <qlabel.h>
#include <qtoolbutton.h>
#include <qmessagebox.h>
#include <qstring.h>
#include <qpixmap.h>

#include <dcapplicationevents.h>

// forward declaration of the DCGui classes
class DCGuiView;
class QDockWindow;
class QTimer;
class TrayIcon;

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class DCGuiView is
  * created which creates your view.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.3 code generation
  */
class DCGuiApp : public QMainWindow
{
Q_OBJECT

public:
	/** construtor */
	DCGuiApp();
	/** destructor */
	virtual ~DCGuiApp();

	/** */
	void ShowOptionsDialog() { slotFileOptions(); };
	/** setup all windows */
	void initWindows();
	/** */
	void Dock() { slotViewDock(); };

protected:
	/** overloaded for Message box on last window exit */
	bool queryExit();
	/** event filter to catch close events for MDI child windows and is installed in createClient() on every child window.
	 * Closing a window calls the eventFilter first which removes the view from the connected documents' view list. If the
	 * last view is going to be closed, the eventFilter() tests if the document is modified; if yes, it asks the user to
	 * save the document. If the document title contains "Untitled", slotFileSaveAs() gets called to get a save name and path.
	 */
	virtual bool eventFilter(QObject* object, QEvent* event);

private slots:

	/** */
	void slotFileOptions();
	/** */
	void slotFileQuickOptions();
	/** */
	void slotFileFileListBrowser();
	/** */
	void slotFileFileListBrowserLocal();
	/** */
	void slotFileCreateShare();
	/** */
	void slotFileReloadPlugins();
	/** change default download mode */
	void slotChangeDefaultDldMode(QAction* DldType);
	/** exits the application */
	bool slotFileQuit();

	/** toggle the tabbar*/
	void slotViewTabBar(bool toggle);
	/** toggle the toolbar*/
	void slotViewToolBar(bool toggle);
	/** toggle the statusbar*/
	void slotViewStatusBar(bool toggle);
	/** dock the application */
	void slotViewDock();
	/** shows an about dlg*/
	void slotHelpAbout();
	/** opens the online manual in web browser */
	void slotHelpManual();
	/** connect to the valknut hub */
	void slotHelpSupport();
	/** check for new versions */
	void slotHelpNewVersion();
	/** change the status message of the whole statusbar temporary */
	void slotStatusHelpMsg(const QString &text);
	/** gets called when the window menu is activated; recreates the window menu with all opened window titles. */
	void windowMenuAboutToShow();
	/** activates the MDI child widget when it gets selected from the window menu. */
	void windowMenuActivated( int id );

	/** show/hide transfer list window */
	void slotActionTransferList();
	/** show/hide server list window */
	void slotActionServerList();
	/** show/hide hub search window */
	void slotActionHubSearch();
	/** show/hide spy window */
	void slotActionSpy();
	/** show/hide users window */
	void slotActionUsers();
	/** change user away mode */
	void slotChangeAwayMode();
	/** show/hide users window */
	void slotActionUpdateManager();

	/** */
	void tileVertically();
	/** minimize all windows */
	void slotWindowMinimize();
	/** */
	void slotWindowCloseChats();
	/** close all disconnected hub windows */
	void slotWindowCloseHubs();

	/** */
	void slotTimeout();
	/** show the tray menu icon */
	void slotTrayMenu( const QPoint&, int );

	/** widget from workspace activated */
	void slotWorkspaceWindowActivated( QWidget * w );

private:
	/** */
	void SetTheme();

	/** initializes all QActions of the application */
	void initActions();
	/** deinitializes all QActions of the application */
	void deinitActions();
	/** initMenuBar creates the menu_bar and inserts the menuitems */
	void initMenuBar();
	/** this creates the toolbars. Change the toobar look and add new toolbars in this
	  * function */
	void initToolBar();
	/** setup the statusbar */
	void initStatusBar();
	/** initialize the mainview*/
	void initView();
	/** deinitialize the mainview*/
	void deinitView();
	/** initialize the tray icon */
	void initTray();
	/** deinitialize the tray icon */
	void deinitTray();
	/** show/hide mdi widget */
	void showMDIWidget( QWidget * widget );
	/** */
	void showFreeDiscSpace();
	
	/** file_menu contains all items of the menubar entry "File" */
	QPopupMenu *pFileMenu;
	/** */
	QPopupMenu *pQuickOptionsMenu;
	/** */
	QPopupMenu *pReloadPluginsMenu;
	/** view_menu contains all items of the menubar entry "View" */
	QPopupMenu *pViewMenu;
	/** view_menu contains all items of the menubar entry "Help" */
	QPopupMenu *pHelpMenu;
	/** the window menu */
	QPopupMenu *pWindowMenu;

	/** action */
	QPopupMenu *pActionMenu;
	/** away mode */
	QPopupMenu *pAwayMenu;
	/** */
	QToolBar *windowsTabBar;
	/** */
	QToolBar *fileToolbar;
	/** */
	QLabel * statusDMLabel;
	/** */
	QLabel * statusFMLabel;
	/** */
	QLabel * statusTRLabel;
	/** */
	QLabel * statusDSLabel;
	/** */
	QWorkspace *pWorkspace;
	/** */
	QAction *fileOptions;
	/** */
	QAction *fileQuickOptions;
	/** */
	QAction *fileFileListBrowser;
	/** */
	QAction *fileFileListBrowserLocal;
	/** */
	QAction *fileReloadPlugins;
	/** */
	QAction *fileQuit;
	/** */
	QActionGroup *fileDefaultDldGroup;
	/** */
	QAction *fileDefaultDldAsk;
	/** */
	QAction *fileDefaultDldSingle;
	/** */
	QAction *fileDefaultDldMulti;
	/** */
	QAction *viewTabBar;
	/** */
	QAction *viewToolBar;
	/** */
	QAction *viewStatusBar;
	/** */
	QAction *viewDock;
	/** */
	QAction *windowTile;
	/** */
	QAction *windowTileHor;
	/** */
	QAction *windowCascade;
	/** */
	QAction *windowMinimize;
	/** */
	QAction *windowCloseChats;
	/** */
	QAction *windowCloseHubs;
	/** */
	QActionGroup *windowAction;
	/** */
	QAction *actionServerList;
	/** */
	QAction *actionTransferList;
	/** */
	QAction *actionHubSearch;
	/** */
	QAction *actionSpy;
	/** */
	QAction *actionUsers;
	/** */
	QActionGroup * actionGroupAwayMode;
	/** */
	QAction *actionAwayModeNormal;
	/** */
	QAction *actionAwayModeAway;
	/** */
	QAction *helpAboutApp;
	/** */
	QAction *helpManualApp;
	/** */
	QAction *helpSupportApp;
	/** */
	QAction *helpNewVersionApp;
	/** */
	QDockWindow * pTransferViewDock;
	/** */
	QTimer * m_pTimer;
	/** */
	DCApplicationEvents m_ApplicationEvents;
	/** tray icon */
	TrayIcon * m_pTrayIcon;
	/** */
	bool m_bTray;
	/** */
	bool m_bEnableTray;
	/** */
	bool m_bTransferViewDockVisible;
	/** hold old desktop position on dock/undock */
	QPoint m_DesktopPosition;
};
#endif
