# Sitescooper::Util.pm -- "static" utility functions.

package Sitescooper::Util;

use Carp;
use strict;

use URI::URL;

#---------------------------------------------------------------------------

sub URLWithoutAnchor {
  my ($url) = @_;
  if (!defined $url) { carp "undef in URLWithoutAnchor"; }
  if ($url =~ /^(.*)#/) {
    $1;
  } else {
    $url;
  }
}

sub URLAnchor {
  my ($url) = @_;
  if (!defined $url) { carp "undef in URLAnchor"; }
  if ($url =~ /#(.*)$/) {
    "#".$1;
  } else {
    "";
  }
}

#---------------------------------------------------------------------------

sub AbsoluteURL {
  my ($fromurl, $relative) = @_;
  local ($_) = $relative;

  s/^\s*\"//; s/\"\s*$//;       # trim quotes if necessary
  s/^\s*\'//; s/\'\s*$//;       # dodgy quotes
  s/^%22//; s/%22.*?$//;        # trim escaped quotes (!!)
  s/&amp;/&/g;                  # HTML escapes are not supposed to be in URLs

  if (/^[^\/]+:/) {
    # experimental: if the URL begins with http:, assume it's already
    # absolute.
    return $_;
    #if (!/^(http|file):/) {
      ## non-HTTP urls get ignored; don't get URI::URL involved, it'll crash
      #return $_;
    #}
  }

  require URI::URL;
  my $url = new URI::URL ($_, $fromurl);
  $url->abs->as_string;
}

#---------------------------------------------------------------------------

1;
