#===========================================================================
# 

package Sitescooper::PerSiteCache;

use Carp;
use Sitescooper::Main;

@ISA = qw();
use vars qw{ @ISA };
use strict;

# ---------------------------------------------------------------------------

sub new {
  my $class = shift; $class = ref($class) || $class;

  my ($main, $factory, $robot, $sitename) = @_;

  my $self = {
    'main'		=> $main,
    'factory'		=> $factory,
    'robot'		=> $robot,
    'sitename'		=> $sitename,
  };

  bless ($self, $class);
  $self;
}

# ---------------------------------------------------------------------------
# Cache commits of pending writes

sub commit {
  my ($self) = @_;
  die "Unimplemented interface in PerSiteCache";
}

# ---------------------------------------------------------------------------
# Cache reads: modification dates

sub set_last_modtime {
  my ($self, $url, $mod) = @_;
  die "Unimplemented interface in PerSiteCache";
}

sub get_last_modtime {
  my ($self, $url) = @_;
  die "Unimplemented interface in PerSiteCache";
}

# ---------------------------------------------------------------------------
# Cache reads: page text

sub get_cached_page {
  my ($self, $url) = @_;
  die "Unimplemented interface in PerSiteCache";
}

sub get_cached_page_for_diff {
  my ($self, $url) = @_;
  die "Unimplemented interface in PerSiteCache";
}

sub get_shared_cache_page {
  my ($self, $url) = @_;
  die "Unimplemented interface in PerSiteCache";
}

# ---------------------------------------------------------------------------
# Cache writes: page text

sub cache_page_now {
  my ($self, $url, $redir_from, $pagehtml) = @_;
  die "Unimplemented interface in PerSiteCache";
}

sub cache_page_at_commit {
  my ($self, $url, $redir_from, $pagehtml) = @_;
  die "Unimplemented interface in PerSiteCache";
}

# ---------------------------------------------------------------------------

1;
