#===========================================================================

package Sitescooper::ConsolePasswordAsker;

use Sitescooper::PasswordAsker;
use Carp;

@ISA = qw(Sitescooper::PasswordAsker);

use strict;

# ---------------------------------------------------------------------------

sub new {
  my ($class, $scoop) = @_; $class = ref($class) || $class;

  my $self = $class->SUPER::new();
  $self = bless $self, $class;
  $self->{scoop} = $scoop;
  $self;
}

# ---------------------------------------------------------------------------

sub ask_user_for_credentials {
  my ($self, $realm, $uri, $proxy) = @_;

  warn ("Need a password to access $realm ($uri).\n");
  if (!-t) { return undef; }

  print STDERR ("Username: ");
  my $user = <STDIN>; chop $user;

  print STDERR ("Password: ");
  ($self->{scoop}->MyOS() eq 'UNIX') and system ("stty -echo");
  my $pass = <STDIN>; chop $pass;
  ($self->{scoop}->MyOS() eq 'UNIX') and system ("stty echo"); print STDERR "\n";

  ($user, $pass);
}

1;
