## Misc small utility functions

note <- function(...) {
    ## A "less drastic" version of warning()
    if (nargs() > 0) {
        message <- paste("Note:",...,"\n")
        cat(message)
    }
}

userQuery <- function(msg, allowed=c("yes","y","no","n")) {
    ## Prompts the user with a string and for an answer
    ## repeats until it gets allowable input
    repeat {
        allowMsg <- paste("[",paste(allowed,collapse="/"),
                          "] ", sep="")
        outMsg <- paste(msg,allowMsg)
        cat(outMsg)
        ans <- readLines(n=1)
        if (ans %in% allowed)
            break
        else
            cat(paste(ans,"is not a valid response, try again.\n"))
    }
    ans
}
