/** 
 * -- Words to open a shared code object
 *
 *  Copyright (C) Tektronix, Inc. 1998 - 2001. All rights reserved.
 *
 *  @see     GNU LGPL
 *  @author  Tektronix CTE                %derived_by: guidod %
 *  @version %version: 1.17 %
 *    (%date_modified: Tue Jul 31 13:27:20 2001 %)
 *
 *  @description
 *		This file exports a set of system words for 
 *              any OS that can dynamically bind object code to
 *		the interpreter. This part will then try to look
 *              up a symbol that can return a loadlist-table to
 *              be fed to the loadlist-loader routine.
 */
/*@{*/
#if defined(__version_control__) && defined(__GNUC__)
static char* id __attribute__((unused)) = 
"@(#) $Id: %full_filespec:  dl-def.c~1.17:csrc:bln_12xx!1 % $";
#endif

#define _P4_SOURCE 1

#ifndef _export
#include <pfe/def-config.h>
#endif

#ifndef PFE_DL_DEF
# ifdef PFE_HAVE_WINCON_H
# define PFE_DL_DEF 3
# endif
#endif

#ifndef PFE_DL_DEF
# if defined PFE_HAVE_LTDL_H || defined PFE_WITH_LTDL \
  || defined PFE_HAVE_DLFCN_H
# define PFE_DL_DEF 4
# endif
#endif

#ifndef PFE_DL_DEF
# if defined HOST_OS_HPUX || defined __target_os_hpux
# define PFE_DL_DEF 9
# endif
#endif

#ifndef PFE_DL_DEF
# if defined HOST_OS_VXWORKS || defined VxWorks || defined __target_os_vxworks
# define PFE_DL_DEF 7
# endif
#endif

#ifndef PFE_DL_DEF
# if defined PFE_HAVE_WINBASE_H
# define PFE_DL_DEF 3
# endif
#endif

#if PFE_DL_DEF == 3
#include "dl-win32.c"
#elif PFE_DL_DEF == 4
#warning dl-dlfcn
#include "dl-dlfcn.c"
#elif PFE_DL_DEF == 7
#warning dl-vxworks
#include "dl-vxworks.c"
#elif PFE_DL_DEF == 9
#warning dl-hpux
#include "dl-hpux.c"
#else 
#warning dl-none
#include "dl-none.c"
#endif 
/* : HAVE_P4_DLFCN layer */

/*@}*/

