// -*- c++ -*-
#ifndef INCLUDED_MATH3D_MPLANE_H
#define INCLUDED_MATH3D_MPLANE_H
/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mplane.h,v 1.1 2000/10/09 17:55:51 jeh Exp $
 */

#ifndef INCLUDED_MATH3D_M3D_H
#include <math3d/m3d.h>
#endif

namespace Math3d {

/**
 * 3-dimensional plane.
 */
  class _CCMATH3D MPlane {
    protected:
      M3d d_n;
      double d_d; 
    public:
      MPlane();
      MPlane(const M3d& n, double d);
      MPlane(const MPlane& p);

      const MPlane& operator=(const MPlane& p);
      void copy(const MPlane& p);

      void setNormal(const M3d& n);
      void setDist(double d);

      const M3d& getNormal() const;
      double getDist() const;

      bool operator==(const MPlane& p) const;
      bool operator!=(const MPlane& p) const;
      bool cmp(const MPlane& p, double epsilon=EPSILON) const;
  };
  
}
#endif // INCLUDED_MATH3D_MPLANE_H
