
/***************************************************************************
                          kmfdoc.cpp  -  description
                             -------------------
    begin                : Mon Jan 28 2002
    copyright            : (C) 2002 by Christian Hubinger
    email                : a9806056@unet.univie.ac.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 
// KDE includes
#include <kdebug.h>
#include <kstandarddirs.h>
#include <kfiledialog.h>
#include <kurl.h>
#include <qfiledialog.h>
#include <kio/job.h>
#include <kio/netaccess.h>
#include <klocale.h>
#include <kprocess.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kmessagebox.h>
#include <ktempfile.h> 
// QT includes
#include "qtextstream.h"
#include "qfile.h"
#include "qxml.h"
#include "qregexp.h"
//#include "qvector.h"
#include "qptrlist.h"
#include "qmessagebox.h"
#include <qstringlist.h>
#include <qvbox.h>
#include <qlabel.h> 
// StdLib includes
#include <iostream.h>
#include <unistd.h>
#include <sys/stat.h> 
// My includes
#include "../version.h"
#include "kmfdoc.h"
#include "../kmfxmlparser.h"
#include "iptchain.h"
#include "iptrule.h"
#include "iptable.h"
#include "kmferror.h"
#include "kmferrorhandler.h"

KMFDoc::KMFDoc( QObject *parent, const char *name ) : QObject( parent, name ) {
	initKMFDoc();
}

KMFDoc::~KMFDoc() {
	kdDebug() << "Callong KMFDoc::~KMFDoc()" << endl;
	delete m_ipt_filter;
	delete m_ipt_nat;
	delete m_ipt_mangle;

	// error handler
	delete m_err_handler;
	delete m_err;
}

void KMFDoc::initKMFDoc() {
	kdDebug() << "\n\nvoid KMFDoc::initKMFDoc()" << endl;
	m_err_handler = new KMFErrorHandler( "KMFDoc" );
	m_err = new KMFError();
	m_url.setFileName(i18n("Untitled"));
	use_filter = true;
	use_nat = true;
	use_mangle = true;
	use_ipfwd = true;
	use_rp_filter = false;
	use_martians = false;
	use_syn_cookies = true;
	use_modules = true;

	is_saved = false;

	m_ipt_filter = new IPTable( this, "filter" );
	m_ipt_nat = new IPTable( this, "nat" );
	m_ipt_mangle = new IPTable( this, "mangle" );
}

void KMFDoc::clear() {
	kdDebug() << "\nvoid KMFDoc::clear()" << endl;
  m_url.setFileName(i18n("Untitled"));
	use_filter = true;
	use_nat = true;
	use_mangle = true;
	use_ipfwd = true;
	use_rp_filter = false;
	use_martians = false;
	use_syn_cookies = true;
	use_modules = true;

	is_saved = false;

	m_ipt_filter->resetTable();
	m_ipt_nat->resetTable();
	m_ipt_mangle->resetTable();
}

void KMFDoc::setUrl( const KURL& url ) {
		m_url = url;
}
void KMFDoc::setFileName( const QString& fileName ) {
		m_url.setFileName( fileName );
}
void KMFDoc::saved() {
	is_saved = true;
}

void KMFDoc::changed() {
	is_saved = false;
	emit documentChanged();
	emit documentChanged( this );
}
void KMFDoc::setUseFilter( bool on ) {
	if ( use_filter != on ) {
		use_filter = on;
		changed();
	}
}
void KMFDoc::setUseNat( bool on ) {
	if ( use_nat != on ) {
		use_nat = on;
		changed();
	}
}
void KMFDoc::setUseMangle( bool on ) {
	if ( use_mangle != on ) {
		use_mangle = on;
		changed();
	}
}

void KMFDoc::setUseIPFwd( bool on ) {
	if ( use_ipfwd != on ) {
		use_ipfwd = on;
		changed();
	}
}

void KMFDoc::setUseRPFilter( bool on ) {
	if ( use_rp_filter != on ) {
		use_rp_filter = on;
		changed();
	}
}
void KMFDoc::setUseMartians( bool on ) {
	if ( use_martians != on ) {
		use_martians = on;
		changed();
	}
}
void KMFDoc::setUseSynCookies( bool on ) {
	if ( use_syn_cookies != on ) {
		use_syn_cookies = on;
		changed();
	}
}
void KMFDoc::setUseModules( bool on ) {
	if ( use_modules != on ) {
		use_modules = on;
		changed();
	}
}

bool KMFDoc::isSaved() {
	return is_saved;
}

bool KMFDoc::isEmpty() {
	if ( m_ipt_filter->chains().isEmpty() && m_ipt_nat->chains().isEmpty() && m_ipt_mangle->chains().isEmpty() ) {
		return true;
	}	else {
	    return false;
	}
	return false;
}

KMFError* KMFDoc::addChain( QString& chain_name, QString& chain_table, QString& chain_target, bool builtin ) {
	kdDebug() << "bool KMFDoc::addChain(QString& chain_name,QString& chain_table,QString& chain_target,bool builtin)" << endl;
	if ( chain_table != "filter" && chain_table != "nat" && chain_table != "mangle" ) {
		kdDebug() << "No Table:" << chain_table << " known by iptables." << endl;
		m_err->setErrType( "NORMAL" );
		const QString& msg = i18n( "No Table: %1 defined by iptables" ).arg( chain_table );
		m_err->setErrMsg( msg );
		return m_err;
	} else {
		m_err = table( chain_table ) ->addChain( chain_name, chain_target, builtin );
		if ( m_err->errNum() == 0 ) {
			is_saved = false;
			emit documentChanged();
		}
		return m_err;
	}
}


IPTRule* KMFDoc::addRule( QString& rule_name, QString& rule_chain, QString& rule_table, QString& rule_target ) {
	kdDebug() << "IPTRule* KMFDoc::addRule(QString& name,QString& chain,QString& table,QString& target)" << endl;

	IPTChain* tmp_chain = table( rule_table ) ->chainForName( rule_chain );

	IPTRule* new_rule = tmp_chain->addRule( rule_name );
	if ( new_rule == 0 )
		return 0;
	new_rule->setTarget( rule_target );
	return new_rule;
}

KMFError* KMFDoc::delChain( IPTChain* chain ) {
	kdDebug() << "bool KMFDoc::delChain(int index)" << endl;
	if ( chain == 0 ) {
		m_err->setErrType( "FATAL" );
		const QString& msg = i18n( "KMFView: m_curr_chain == 0. This is a bug." );
		m_err->setErrMsg( msg );
		return m_err;
	}
	m_err = chain->table() ->delChain( chain );
	if ( m_err->errNum() == 0 ) {
		emit documentChanged();
		return m_err;
	}
	return m_err;
}

bool KMFDoc::delChainRule( IPTRule& rule ) {
	kdDebug() << "KMFDoc::delChainRule(IPTRule& rule)" << endl;
	QString rule_chain = rule.chain() ->name();
	QString rule_table = rule.table() ->name();
	for ( uint i = 0;i < table( rule_table ) ->chains().count();i++ ) {
		IPTChain& chain = *table( rule_table ) ->chains().at( i );
		QString chain_name = chain.name();
		if ( rule_chain == chain_name ) {
			chain.delRule( rule );
			is_saved = false;
			emit documentChanged();
			return true;
		}
	}
	kdDebug() << "!!! Can't Add Del to not defined Rule '" << rule_chain << "' !!!" << endl;
	return false;
}

QPtrList<IPTChain> KMFDoc::chains( const QString& table ) {
	if ( table == "filter" )
		return m_ipt_filter->chains();
	if ( table == "nat" )
		return m_ipt_nat->chains();
	if ( table == "mangle" )
		return m_ipt_mangle->chains();
	return m_ipt_filter->chains();
}

IPTChain* KMFDoc::chain( QString& name, QString& table ) {
	kdDebug() << "IPTChain* KMFDoc::chain(QString& name, QString& table)" << endl;
	kdDebug() << i18n( "Searching for chain: %1 in table: %2" ).arg( name ).arg( table ) << endl;
	if ( table == "filter" ) {
		for ( uint i = 0;i < m_ipt_filter->chains().count(); i++ ) {
			IPTChain* tmp_chain = m_ipt_filter->chains().at( i );
			QString tmp_name = tmp_chain->name();
			if ( tmp_name == name ) {
				return tmp_chain;
			}
		}
	}
	if ( table == "nat" ) {
		for ( uint i = 0;i < m_ipt_nat->chains().count(); i++ ) {
			IPTChain* tmp_chain = m_ipt_nat->chains().at( i );
			QString tmp_name = tmp_chain->name();
			if ( tmp_name == name ) {
				return tmp_chain;
			}
		}
	}
	if ( table == "mangle" ) {
		for ( uint i = 0;i < m_ipt_mangle->chains().count(); i++ ) {
			IPTChain* tmp_chain = m_ipt_mangle->chains().at( i );
			QString tmp_name = tmp_chain->name();
			if ( tmp_name == name ) {
				return tmp_chain;
			}
		}
	}
	return 0;
}

IPTable* KMFDoc::table( const QString& table ) {
	if ( table == "filter" )
		return m_ipt_filter;
	if ( table == "nat" )
		return m_ipt_nat;
	if ( table == "mangle" )
		return m_ipt_mangle;
	return 0;
}

KMFError* KMFDoc::createInitScript( const QString& initfile ) {
	kdDebug() << "KMFError* KMFDoc::createInitScript(const QString& initfile)" << endl;
	if ( !initfile || initfile.isEmpty() ) {
		m_err->setErrType( "NORMAL" );
		const QString& msg = i18n( "No filename given for script creation." );
		m_err->setErrMsg( msg );
		return m_err;
	}

	KConfig* _config = kapp->config();
	_config->setGroup( "PATHS" );
	QString gentoo_mode = _config->readEntry( "gentoo_mode" );
	kdDebug() << "gentoo_mode = " << gentoo_mode << endl;

	kdDebug() << "Writing script to file " << initfile << endl;
	QFile f( initfile );
	f.remove();
	bool gotit = f.open( IO_ReadWrite );
	if ( gotit ) {
		QTextStream ts( &f );
		//Header
		QString version = KMYFIREWALL_VERSION;
		QString s;
		if ( gentoo_mode == "false" ) {
			kdDebug() << "Writing normal init script." << endl;
			s = "#!/bin/sh\n"
			    "#\n"
			    "# copyright (c) the KMyFirewall developers 2002\n"
			    "# 	mail to: Christian Hubinger <a9806056@unet.univie.ac.at>\n"
			    "#\n"
			    "# Start/Stop script for KMyFirewall " + version + "\n"
			    "# This is an automatic generated file DO NOT EDIT\n"
			    "#\n"
			    "status=\"0\"\n"
			    "case $1 in\n"
			    "	start)\n"
			    "	/bin/sh /etc/kmyfirewall/kmyfirewall.sh start || status=\"1\"\n"
			    "	;;\n\n"
			    "	stop)\n"
			    "	/bin/sh /etc/kmyfirewall/kmyfirewall.sh stop || status=\"1\"\n"
			    "	;;\n\n"
			    "	reload)\n"
			    "	/bin/sh /etc/kmyfirewall/kmyfirewall.sh stop || status=\"1\"\n"
			    "	/bin/sh /etc/kmyfirewall/kmyfirewall.sh start || status=\"1\"\n"
			    "	;;\n\n"
			    "esac\n"
			    "if [ \"$status\" = \"0\" ]; then\n"
			    "	exit 0\n"
			    "else\n"
			    "	exit 1\n"
			    "fi\n";
			ts << s << endl;
		} else {
			kdDebug() << "Writing Gentoo init script." << endl;
			s = "#!/sbin/runscript\n"
			    "#\n"
			    "# copyright (c) the KMyFirewall developers 2002\n"
			    "# 	mail to: Christian Hubinger <a9806056@unet.univie.ac.at>\n"
			    "#\n"
			    "# Gentoo Start/Stop script for KMyFirewall " + version + "\n"
			    "# This is an automatic generated file DO NOT EDIT\n"
			    "#\n"
			    "depend() { \n"
			    "need net \n"
			    "}\n"
			    "start() {\n"
			    "	/bin/sh /etc/kmyfirewall/kmyfirewall.sh start\n"
			    "eend $? \n"
			    "}\n\n"
			    "stop () {\n"
			    "	/bin/sh /etc/kmyfirewall/kmyfirewall.sh stop\n"
			    "eend $? \n"
			    "}\n\n";
			ts << s << endl;
		}
		f.flush();
		f.close();
	} else {
		m_err->setErrType( "NORMAL" );
		const QString& msg = i18n( "<p>Opening file for writing <b>failed</b>."
		                           "Please make sure that you are logged in as <b>root</b>." );
		m_err->setErrMsg( msg );
		return m_err;
	}
	m_err->setErrType( "OK" );
	const QString& msg = "";
	m_err->setErrMsg( msg );
	return m_err;
}

KMFError* KMFDoc::createFirewallScript( const QString& fi ) {
	kdDebug() << "void KMFDoc::createFirewallScript(const QString& fi)" << endl;
	KConfig* _config = kapp->config();
	_config->setGroup( "PATHS" );
	QString str_ipt = _config->readPathEntry( "ipt_path" );
	kdDebug() << "Found ipt path " << str_ipt << endl;
	QString str_modprobe = _config->readPathEntry( "modprobe_path" );
	kdDebug() << "Found ipt path " << str_ipt << endl;

	if ( str_ipt.isEmpty() ) {
		m_err->setErrType( "NORMAL" );
		const QString& msg = i18n( "There is no path set for the iptables program." );
		m_err->setErrMsg( msg );
		return m_err;
	}

	if ( str_modprobe.isEmpty() ) {
		m_err->setErrType( "NORMAL" );
		const QString& msg = i18n( "There is no path set for the modprobe program." );
		m_err->setErrMsg( msg );
		return m_err;
	}


	QString file;

	if ( fi.isEmpty() ) {
		KURL url = KGlobal::dirs() ->findResource( "appdata", "scripts/" );
		file = url.path();
		kdDebug() << "Scriptdir: " << file << endl;
		file = file + "kmyfirewall.sh";
		kdDebug() << "Scriptfile: " << file << endl;
	} else {
		file = fi;
	}

	if ( !file.isEmpty() ) {
		kdDebug() << "Writing script to file " << file << endl;
		QFile f( file );
		f.remove();
		bool gotit = f.open( IO_ReadWrite );
		if ( gotit ) {
			QTextStream ts( &f );
			//Header
			QString version = KMYFIREWALL_VERSION;
			QString s;
			s = "#!/bin/sh\n"
			    "#\n"
			    "# copyright (c) the KMyFirewall developers 2002\n"
			    "#      mail to: Christian Hubinger <e9806056@student.tuwien.ac.at>\n"
			    "#\n"
			    "# KMyFirewall v" + version + "\n"
			    "# This is an automatic generated file DO NOT EDIT\n"
			    "#\n"
			    "IPT=\"" + str_ipt + "\"\n"
			    "MOD=\"" + str_modprobe + "\"\n"
			    "status=\"0\"\n";
			ts << s << endl;
			// write start function
			s = "startFirewall() {\n"
			    "echo\n"
			    "echo \"Starting firewall...\"";
			ts << s << endl;
			if ( useModules() ) {
				s = "echo -n \"Loading needed modules...          \"";
				ts << s << endl;
				s = "$MOD ip_tables \n"
				    "$MOD ip_conntrack \n"
				    "$MOD ipt_LOG \n"
				    "$MOD ipt_limit \n"
				    "$MOD ipt_state \n"
				    "$MOD ip_conntrack_ftp\n"
				    "$MOD ip_conntrack_irc";
				ts << s << endl;
				if ( useFilter() ) {
					s = "$MOD iptable_filter";
					ts << s << endl;
				}
				if ( useNat() ) {
					s = "$MOD iptable_nat";
					ts << s << endl;
				}
				if ( useMangle() ) {
					s = "$MOD iptable_mangle";
					ts << s << endl;
				}
				s = "echo \"Done.\"";
				ts << s << endl;
			}

			// Chain Definitions
			s = "#  Define all custom chains";
			ts << s << endl;
			s = "echo -n \"Create custom chains...                \"";
			ts << s << endl;
			if ( useFilter() ) {
				for ( uint i = 0;i < m_ipt_filter->chains().count();i++ ) {
					IPTChain* c = m_ipt_filter->chains().at( i );
					if ( !c->isBuildIn() ) {
						s = c->name();
						s = "\n#  Create Chain: " + s;
						ts << s << endl;
						s = c->createIPTablesChainDefinition();
						if ( !s.isEmpty() ) {
							ts << s << " || { status=\"1\"; echo \"Setting up Chain: " + c->name() + " FAILED !!!\"; exit 1; }\n";
							//     		     	kdDebug() << s << " || status=\"1\"" << endl;
						}
					}
				}
			}
			if ( useNat() ) {
				for ( uint i = 0;i < m_ipt_nat->chains().count();i++ ) {
					IPTChain* c = m_ipt_nat->chains().at( i );
					if ( !c->isBuildIn() ) {
						s = c->name();
						s = "\n#  Create Chain: " + s;
						ts << s << endl;
						s = c->createIPTablesChainDefinition();
						if ( !s.isEmpty() ) {
							ts << s << " || { status=\"1\"; echo \"Setting up Chain: " + c->name() + " FAILED !!!\"; exit 1; }\n";
							//     		     	kdDebug() << s << " || status=\"1\"" << endl;
						}
					}
				}
			}
			if ( useMangle() ) {
				for ( uint i = 0;i < m_ipt_mangle->chains().count();i++ ) {
					IPTChain* c = m_ipt_mangle->chains().at( i );
					if ( !c->isBuildIn() ) {
						s = c->name();
						s = "\n#  Create Chain: " + s;
						ts << s << endl;
						s = c->createIPTablesChainDefinition();
						if ( !s.isEmpty() ) {
							ts << s << " || { status=\"1\"; echo \"Setting up Chain: " + c->name() + " FAILED !!!\"; exit 1; }\n";
							//     		     	kdDebug() << s << endl;
						}
					}
				}
			}
			s = "  echo \"Done.\"";
			ts << s << endl;
			// Rules
			s = "\n#  Rules:";
			ts << s << endl;
			if ( useFilter() ) {
				s = "\necho \"Settup Rules in Table FILTER:\n\"";
				ts << s << endl;
				for ( uint i = 0;i < m_ipt_filter->chains().count();i++ ) {
					IPTChain* c = m_ipt_filter->chains().at( i );
					s = c->name();
					s = "\n#  Define Rules for Chain: " + s;
					ts << s << endl;
					// Output for debugging while running the script
					s = "echo -n \"Create Rules for Chain: ";
					ts << s ;
					s = c->name();
					ts << s << "                    \"" << endl;
					QPtrList<QStringList> rules = c->createIPTablesChainRules();
					QStringList* curr_rule;
					QString rule_name;
					for ( curr_rule = rules.first(); curr_rule; curr_rule = rules.next() ) {
						rule_name = *curr_rule->at( 0 );
						s = *curr_rule->at( 1 );
						if ( !s.isEmpty() ) {
							ts << s << " || { status=\"1\"; echo \"Setting up Rule: " + rule_name + " FAILED !!!\"; exit 1; }\n" << endl;
						}
					}
					s = "echo \"Done.\"";
					ts << s << endl;
				}
			}
			if ( useNat() ) {
				s = "\necho \"Settup Rules in Table NAT:\n\"";
				ts << s << endl;
				for ( uint i = 0;i < m_ipt_nat->chains().count();i++ ) {
					IPTChain* c = m_ipt_nat->chains().at( i );
					s = c->name();
					s = "\n#  Define Rules for Chain: " + s;
					ts << s << endl;
					// Output for debugging while running the script
					s = "echo -n \"Create Rules for Chain: ";
					ts << s ;
					s = c->name();
					ts << s << "                    \"" << endl;
					QPtrList<QStringList> rules = c->createIPTablesChainRules();
					QStringList* curr_rule;
					QString rule_name;
					for ( curr_rule = rules.first(); curr_rule; curr_rule = rules.next() ) {
						rule_name = *curr_rule->at( 0 );
						s = *curr_rule->at( 1 );
						if ( !s.isEmpty() ) {
							ts << s << " || { status=\"1\"; echo \"Setting up Rule: " + rule_name + " FAILED !!!\"; exit 1; }\n" << endl;
						}
					}
					s = "echo \"Done.\"";
					ts << s << endl;
				}
			}
			if ( useMangle() ) {
				s = "\necho \"Settup Rules in Table MANGLE:\n\"";
				ts << s << endl;
				for ( uint i = 0;i < m_ipt_mangle->chains().count();i++ ) {
					IPTChain* c = m_ipt_mangle->chains().at( i );
					s = c->name();
					s = "\n#  Define Rules for Chain: " + s;
					ts << s << endl;
					// Output for debugging while running the script
					s = "echo -n \"Create Rules for Chain: ";
					ts << s ;
					s = c->name();
					ts << s << "                    \"" << endl;
					QPtrList<QStringList> rules = c->createIPTablesChainRules();
					QStringList* curr_rule;
					QString rule_name;
					for ( curr_rule = rules.first(); curr_rule; curr_rule = rules.next() ) {
						rule_name = *curr_rule->at( 0 );
						s = *curr_rule->at( 1 );
						if ( !s.isEmpty() ) {
							ts << s << " || ( status=\"1\" && echo \"Setting up Rule: " + rule_name + " FAILED !!!\" && exit 1 )\n" << endl;
						}
					}
					s = "echo \"Done.\"";
					ts << s << endl;
				}
			}
			if ( useIPFwd() ) {
				s = "\necho -n \"Enable IP Forwarding.                \"";
				ts << s << endl;
				s = "echo 1 > /proc/sys/net/ipv4/ip_forward";
				ts << s << endl;
				s = "echo \"Done.\"";
				ts << s << endl;
			} else {
				s = "echo -n \"Disable IP Forwarding.		\"";
				ts << s << endl;
				s = "echo 0 > /proc/sys/net/ipv4/ip_forward";
				ts << s << endl;
				s = "echo \"Done.\n\"";
				ts << s << endl;
			}

			if ( useRPFilter() ) {
				s = "\n echo -n \"Enable Reverse Path Filtering      \"";
				ts << s << endl;

				s = "for i in /proc/sys/net/ipv4/conf/*/rp_filter ; do";
				ts << s << endl;
				s = "echo 2 > $i ";
				ts << s << endl;
				s = "done";
				ts << s << endl;

				s = "echo \"Done.\"";
				ts << s << endl;
			} else {
				s = "echo -n \"Disable Reverse Path Filtering       \"";
				ts << s << endl;

				s = "for i in /proc/sys/net/ipv4/conf/*/rp_filter ; do";
				ts << s << endl;
				s = "echo 0 > $i ";
				ts << s << endl;
				s = "done";
				ts << s << endl;

				s = "echo \"Done.\n\"";
				ts << s << endl;
			}

			if ( useMartians() ) {
				s = "\n echo -n \"Enable log_martians (logging).             \"";
				ts << s << endl;

				s = "for i in /proc/sys/net/ipv4/conf/*/log_martians ; do";
				ts << s << endl;
				s = "echo 1 > $i ";
				ts << s << endl;
				s = "done";
				ts << s << endl;


				s = "echo \"Done.\"";
				ts << s << endl;
			} else {
				s = "echo -n \"Disable log_martians (logging).           \"";
				ts << s << endl;

				s = "for i in /proc/sys/net/ipv4/conf/*/log_martians ; do";
				ts << s << endl;
				s = "echo 0 > $i ";
				ts << s << endl;
				s = "done";
				ts << s << endl;

				s = "echo \"Done.\n\"";
				ts << s << endl;
			}

			if ( useSynCookies() ) {
				s = "\n echo -n \"Enable Syn Cookies.          \"";
				ts << s << endl;

				s = "echo 1 > /proc/sys/net/ipv4/tcp_syncookies";
				ts << s << endl;

				s = "echo \"Done.\"";
				ts << s << endl;
			} else {
				s = "echo -n \"Disable Syn Cookies.          \"";
				ts << s << endl;

				s = "echo 0 > /proc/sys/net/ipv4/tcp_syncookies";
				ts << s << endl;

				s = "echo \"Done.\n\"";
				ts << s << endl;
			}


			s = "}";
			ts << s << endl;
			// write stop function
			s = "stopFirewall() {\n"
			    "  echo -n \"Shutdown KMyFirewall...       \"\n";
			ts << s << endl;
			if ( useFilter() ) {
				s = "  $IPT -t filter -F || status=\"1\"\n"
				    "  $IPT -t filter -X || status=\"1\"\n"
				    "  $IPT -t filter -P INPUT ACCEPT || status=\"1\"\n"
				    "  $IPT -t filter -P OUTPUT ACCEPT || status=\"1\"\n"
				    "  $IPT -t filter -P FORWARD ACCEPT || status=\"1\"\n";
				ts << s << endl;
			}
			if ( useNat() ) {
				s = "  $IPT -t nat -F || status=\"1\"\n"
				    "  $IPT -t nat -X || status=\"1\"\n"
				    "  $IPT -t nat -P OUTPUT ACCEPT || status=\"1\"\n"
				    "  $IPT -t nat -P PREROUTING ACCEPT || status=\"1\"\n"
				    "  $IPT -t nat -P POSTROUTING ACCEPT || status=\"1\"\n";
				ts << s << endl;
			}
			if ( useMangle() ) {
				s = "  $IPT -t mangle -F || status=\"1\"\n"
				    "  $IPT -t mangle -X || status=\"1\"\n"
				    "  $IPT -t mangle -P INPUT ACCEPT || status=\"1\"\n"
				    "  $IPT -t mangle -P OUTPUT ACCEPT || status=\"1\"\n"
				    "  $IPT -t mangle -P OUTPUT ACCEPT || status=\"1\"\n"
				    "  $IPT -t mangle -P PREROUTING ACCEPT || status=\"1\"\n"
				    "  $IPT -t mangle -P POSTROUTING ACCEPT || status=\"1\"\n";
				ts << s << endl;
			}
			s = "	echo \"Done.\"\n";
			ts << s << endl;
			s = "}";
			ts << s << endl;
			s = "case $1 in\n"
			    "  start)\n"
			    "  stopFirewall\n"
			    "  startFirewall\n"
			    "  ;;\n"
			    "  stop)\n"
			    "  stopFirewall\n"
			    "  ;;\n"
			    "  restart)\n"
			    "  stopFirewall\n"
			    "  startFirewall\n"
			    "  ;;\n"
			    "  *)\n"
			    "  echo \"Usage: sh kmyfirewall.sh { start | stop | restart } \"\n"
			    "  ;;\n"
			    "  esac\n";
			ts << s << endl;
			s = "if [ \"$status\" = \"1\" ]; then\n"
			    "  exit 1\n"
			    "else\n"
			    "  exit 0\n"
			    "fi\n";
			ts << s << endl;
			f.flush();
			f.close();
			m_err->setErrType( "OK" );
			const QString& msg = i18n( "" );
			m_err->setErrMsg( msg );
			return m_err;
		} else {
			m_err->setErrType( "NORMAL" );
			const QString& msg = i18n( "Opening file for writing failed.\n"
			                           "Please make sure that you are logged in as root." );
			m_err->setErrMsg( msg );
			return m_err;
		}
	} else {
		kdDebug() << "Cant open output file" << endl;
		m_err->setErrType( "NORMAL" );
		const QString& msg = i18n( "Opening file for writing failed.\n"
		                           "Please make sure that you are logged in as root." );
		m_err->setErrMsg( msg );
		return m_err;
	}
}

KMFDoc* KMFDoc::parseXMLRuleset( const KURL& url ) {
	kdDebug() << "KMFDoc::parseXMLRuleset()" << endl;
	QString xmlfile;
  if (! KIO::NetAccess::download( url, xmlfile ) ) {
    clear();
    m_url.setFileName( i18n("Untitled") );
		return this;
	}

	if ( !xmlfile.isEmpty() ) {
		kdDebug() << "Found xmlfile: " << xmlfile << endl;
		// delete old chainsets if there
		if ( !m_ipt_filter->chains().isEmpty() )
			m_ipt_filter->resetTable();
		if ( !m_ipt_nat->chains().isEmpty() )
			m_ipt_nat->resetTable();
		if ( !m_ipt_mangle->chains().isEmpty() )
			m_ipt_mangle->resetTable();
		KMFXMLParser* kmfparser = new KMFXMLParser();
		KMFDoc* doc = kmfparser->parseKMFRS( xmlfile );
    doc->setUrl(url);
    emit documentChanged();
    KIO::NetAccess::removeTempFile( xmlfile );
		return doc;
	}
  KIO::NetAccess::removeTempFile( xmlfile );
	return this;
}               

KMFError* KMFDoc::exportXMLRuleset( const KURL& url ) {
	kdDebug() << "bool KMFDoc::exportXMLRuleset(const QString& filename)" << endl;
  KTempFile file;
	KMFXMLParser* kmfparser = new KMFXMLParser();
	m_err = kmfparser -> writeKMFRS( this, file.name() );
  if ( ! KIO::NetAccess::upload(file.name(),url) ) {
		kdDebug() << "Coudn't save File: "<< url.url() << endl;
	  m_err->setErrType("NORMAL");
	  m_err->setErrMsg(i18n("<qt><p><b>Saving <i>%1</i> Failed!</b></p>"
													"<p>Please make shure that you have the permissions to write to this Directory.<br>"
													"If you are working with remotley stored files "
													"make shure that the target host and the directory is reachable. "
													"</p></qt>").arg( url.url() ) );
	}
  file.unlink();
	return m_err;
}

const QString& KMFDoc::getXMLRuleset() {
	kdDebug() << "QString KMFDoc::getXMLRuleset() {" << endl;
	KMFXMLParser* kmfparser = new KMFXMLParser();
	return kmfparser -> writeKMFRS( this );
}

#include "kmfdoc.moc"
