#ifndef _MPC_MATH_H_
#define _MPC_MATH_H_


// #define MPC_FIXED_POINT


#ifdef _MSC_VER
typedef __int64 MPC_INT64;
#else
typedef long long MPC_INT64;
#endif


#define MPC_FIXED_POINT_SHIFT 16

#ifdef MPC_FIXED_POINT

#define MPC_FIXED_POINT_SCALE_SHIFT (MPC_FIXED_POINT_SHIFT + MPC_FIXED_POINT_FRACTPART)
#define MPC_FIXED_POINT_SCALE (1 << (MPC_FIXED_POINT_SCALE_SHIFT - 1))


//in fixedpoint mode, results in decode output buffer are in -MPC_FIXED_POINT_SCALE ... MPC_FIXED_POINT_SCALE range

#define MPC_FIXED_POINT_FRACTPART 14
typedef long MPC_SAMPLE_FORMAT;

typedef MPC_INT64 MPC_SAMPLE_FORMAT_MULTIPLY;

#define MAKE_MPC_SAMPLE(X) (MPC_SAMPLE_FORMAT)((double)(X) * (double)(((MPC_INT64)1)<<MPC_FIXED_POINT_FRACTPART))
#define MAKE_MPC_SAMPLE_EX(X,Y) (MPC_SAMPLE_FORMAT)((double)(X) * (double)(((MPC_INT64)1)<<(Y)))

#define MPC_MULTIPLY_NOTRUNCATE(X,Y) \
	(((MPC_SAMPLE_FORMAT_MULTIPLY)(X) * (MPC_SAMPLE_FORMAT_MULTIPLY)(Y)) >> MPC_FIXED_POINT_FRACTPART)

#define MPC_MULTIPLY_EX_NOTRUNCATE(X,Y,Z) \
	(((MPC_SAMPLE_FORMAT_MULTIPLY)(X) * (MPC_SAMPLE_FORMAT_MULTIPLY)(Y)) >> (Z))

#ifdef _DEBUG
static inline MPC_SAMPLE_FORMAT MPC_MULTIPLY(MPC_SAMPLE_FORMAT item1,MPC_SAMPLE_FORMAT item2)
{
	MPC_SAMPLE_FORMAT_MULTIPLY temp = MPC_MULTIPLY_NOTRUNCATE(item1,item2);
	assert(temp == (MPC_SAMPLE_FORMAT_MULTIPLY)(MPC_SAMPLE_FORMAT)temp);
	return (MPC_SAMPLE_FORMAT)temp;
}

static inline MPC_SAMPLE_FORMAT MPC_MULTIPLY_EX(MPC_SAMPLE_FORMAT item1,MPC_SAMPLE_FORMAT item2,unsigned shift)
{
	MPC_SAMPLE_FORMAT_MULTIPLY temp = MPC_MULTIPLY_EX_NOTRUNCATE(item1,item2,shift);
	assert(temp == (MPC_SAMPLE_FORMAT_MULTIPLY)(MPC_SAMPLE_FORMAT)temp);
	return (MPC_SAMPLE_FORMAT)temp;
}

#else

#define MPC_MULTIPLY(X,Y) ((MPC_SAMPLE_FORMAT)MPC_MULTIPLY_NOTRUNCATE(X,Y))
#define MPC_MULTIPLY_EX(X,Y,Z) ((MPC_SAMPLE_FORMAT)MPC_MULTIPLY_EX_NOTRUNCATE(X,Y,Z))

#endif

#define MPC_MULTIPLY_FLOAT_INT(X,Y) ((X)*(Y))
#define MPC_SCALE_CONST(X,Y,Z) MPC_MULTIPLY_EX(X,MAKE_MPC_SAMPLE_EX(Y,Z),(Z))
#define MPC_SCALE_CONST_SHL(X,Y,Z,S) MPC_MULTIPLY_EX(X,MAKE_MPC_SAMPLE_EX(Y,Z),(Z)-(S))
#define MPC_SCALE_CONST_SHR(X,Y,Z,S) MPC_MULTIPLY_EX(X,MAKE_MPC_SAMPLE_EX(Y,Z),(Z)+(S))
#define MPC_SHR(X,Y) ((X)>>(Y))
#define MPC_SHL(X,Y) ((X)<<(Y))

#else

//in floating-point mode, decoded samples are in -1...1 range

typedef float MPC_SAMPLE_FORMAT;

#define MAKE_MPC_SAMPLE(X) ((MPC_SAMPLE_FORMAT)(X))
#define MAKE_MPC_SAMPLE_EX(X,Y) ((MPC_SAMPLE_FORMAT)(X))

#define MPC_MULTIPLY_FLOAT_INT(X,Y) ((X)*(Y))
#define MPC_MULTIPLY(X,Y) ((X)*(Y))
#define MPC_MULTIPLY_EX(X,Y,Z) ((X)*(Y))
#define MPC_SCALE_CONST(X,Y,Z) ((X)*(Y))
#define MPC_SCALE_CONST_SHL(X,Y,Z,S) ((X)*(Y))
#define MPC_SCALE_CONST_SHR(X,Y,Z,S) ((X)*(Y))
#define MPC_SHR(X,Y) (X)
#define MPC_SHL(X,Y) (X)

#endif

#endif
