#include "hx_types.h"
#include <stdio.h>
#include <netinet/in.h>
#include "hx.h"
#include "hxlib.h"
#include "dhargs.h"
#include "screen.h"
#include "xmalloc.h"

#if defined(__HAL__)
#include <string.h>
#include "auto_array.h"

extern int hal_active;
extern void hal_rcv (char *, char *);
#endif

void
rcv_chat (void)
{
	u_int32_t pcref = 0;
	char chat[4096];
	u_int16_t len = 0;

	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		switch (ntohs(dh->type)) {
			case HTLC_DATA_CHAT_REF:
				dh_getint(pcref);
				break;
			case HTLC_DATA_CHAT:
				len = ntohs(dh->len) > 4096 ? 4096 : ntohs(dh->len);
				memcpy(chat, dh->data, len);
				break;
		}
	dh_end()
	if (!len)
		goto ret;
	CR2LF(chat, len);
#if defined(__HAL__) && __HAL__ == 6900
	if (hal_active && (!curchat || (curchat->ref == pcref))) {
		register char *user;
		auto_array(chat, buf, len);
		buf[14] = 0;
		user = &(buf[1]);
		while (*user == ' ' && *user)
			user++;
		if (strcmp(user, hx_prefs.nick))
			hal_rcv(&(buf[17]), user);
		auto_free(buf);
	}
#endif
	if (!pcref)
		curscr_puts(chat, len);
	else
		curscr_printf("\n0x%x:%.*s", pcref, len - 1, &(chat[1]));
ret:
	hx_reset();
}

char last_msg[16] = "\0";

void
rcv_msg (void)
{
	u_int32_t sock = 0;
	u_int16_t msglen = 0, nlen = 0;
	char nick[32], msg[0xffff];

	nick[0] = 0;
	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		switch (ntohs(dh->type)) {
			case HTLC_DATA_SOCKET:
				dh_getint(sock);
				break;
			case HTLC_DATA_NICK:
				nlen = ntohs(dh->len) > 31 ? 31 : ntohs(dh->len);
				memcpy(nick, dh->data, nlen);
				break;
			case HTLC_DATA_MSG:
				msglen = ntohs(dh->len);
				memcpy(msg, dh->data, msglen);
				break;
		}
	dh_end()
	if (!msglen)
		goto ret;
	CR2LF(msg, msglen);
#if defined(__HAL__) && __HAL__ == 6900
	if (hal_active) {
		hal_rcv(msg, nick);
	}
#endif
	curscr_printf("\n[%.*s(%u)]: %.*s", nlen, nick, sock, msglen, msg);
	snprintf(last_msg, 16, "/msg %u ", sock);
ret:
	hx_reset();
}

void rcv_agreement (void);
void rcv_hdr (void);

void
rcv_agreement (void)
{
	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		if (ntohs(dh->type) != HTLS_DATA_AGREEMENT)
			continue;
		CR2LF(dh->data, ntohs(dh->len));
		curscr_printf("\nAgreement:\n%.*s", ntohs(dh->len), dh->data);
	dh_end()
	hx_reset();
}

void
rcv_hdr (void)
{
	struct hx_hdr *h = (struct hx_hdr *)hx_buf;
	register u_int32_t type = ntohl(h->type), len = ntohl(h->len);

	if (len >= 2)
		len -= 2;
	switch (type) {
		case HTLS_HDR_CHAT:
			hx_set(rcv_chat, len);
			break;
		case HTLS_HDR_MSG:
			hx_set(rcv_msg, len);
			break;
		case HTLS_HDR_USER_CHANGE:
			hx_set(rcv_user_change, len);
			break;
		case HTLS_HDR_USER_LEAVE:
			hx_set(rcv_user_leave, len);
			break;
		case HTLS_HDR_TASK:
			hx_set(rcv_task, len);
			break;
		case HTLS_HDR_NEWS_POST:
			hx_set(rcv_news_post, len);
			break;
		case HTLS_HDR_CHAT_USER_CHANGE:
			hx_set(rcv_chat_user_change, len);
			break;
		case HTLS_HDR_CHAT_USER_LEAVE:
			hx_set(rcv_chat_user_leave, len);
			break;
		case HTLS_HDR_CHAT_SUBJECT:
			hx_set(rcv_chat_subject, len);
			break;
		case HTLS_HDR_CHAT_INVITE:
			hx_set(rcv_chat_invite, len);
			break;
		case HTLS_HDR_AGREEMENT:
			hx_set(rcv_agreement, len);
			break;
		default:
			curscr_printf("\nunknown header type 0x%lx", (unsigned long)type);
			hx_set(0, len);
	}

	if (!len) {
		if (hx_fun)
			hx_fun();
		else
			hx_reset();
	}
}
