/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import java.util.Hashtable;
import org.apache.xerces.utils.QName;
import org.apache.xerces.validators.common.ContentLeafNameTypeVector;
import org.apache.xerces.validators.common.ElementWildcard;
import org.apache.xerces.validators.common.InsertableElementsInfo;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;

public class AllContentModel
implements XMLContentModel {
    private QName[] fAllElements = new QName[10];
    private boolean[] fIsOptionalElement = new boolean[10];
    private boolean fHasOptionalContent = false;
    private boolean fIsMixed = false;
    private int fNumElements = 0;
    private int fNumRequired = 0;
    private Hashtable fElementsHash;
    private SubstitutionGroupComparator fComparator = null;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;

    public AllContentModel(boolean bl) {
        this.fHasOptionalContent = bl;
    }

    public AllContentModel(boolean bl, boolean bl2) {
        this(bl);
        this.fIsMixed = bl2;
    }

    void addElement(QName qName, boolean bl) {
        if (this.fNumElements < this.fAllElements.length) {
            QName[] qNameArray = new QName[2 * this.fAllElements.length];
            boolean[] blArray = new boolean[2 * this.fIsOptionalElement.length];
            System.arraycopy(this.fAllElements, 0, qNameArray, 0, this.fAllElements.length);
            System.arraycopy(this.fIsOptionalElement, 0, blArray, 0, this.fIsOptionalElement.length);
            this.fAllElements = qNameArray;
            this.fIsOptionalElement = blArray;
        }
        this.fAllElements[this.fNumElements] = qName;
        this.fIsOptionalElement[this.fNumElements] = bl;
        ++this.fNumElements;
        if (!bl) {
            ++this.fNumRequired;
        }
    }

    public void checkUniqueParticleAttribution(SchemaGrammar schemaGrammar) throws Exception {
        int n = 0;
        while (n < this.fNumElements) {
            this.fAllElements[n].uri = schemaGrammar.getContentSpecOrgUri(this.fAllElements[n].uri);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.fNumElements) {
            int n3 = n2 + 1;
            while (n3 < this.fNumElements) {
                ElementWildcard.conflict(0, this.fAllElements[n2].localpart, this.fAllElements[n2].uri, 0, this.fAllElements[n3].localpart, this.fAllElements[n3].uri, this.fComparator);
                ++n3;
            }
            ++n2;
        }
    }

    private void createElementsHash() {
        int n = this.fNumElements;
        this.fElementsHash = new Hashtable(n);
        int n2 = 0;
        while (n2 < n) {
            this.fElementsHash.put(this.fAllElements[n2], new Integer(n2));
            ++n2;
        }
    }

    public ContentLeafNameTypeVector getContentLeafNameTypeVector() {
        return null;
    }

    public void setSubstitutionGroupComparator(SubstitutionGroupComparator substitutionGroupComparator) {
        this.fComparator = substitutionGroupComparator;
    }

    private void showAllElements() {
        int n = 0;
        while (n < this.fNumElements) {
            System.out.print("fAllElements[" + n + "] == " + this.fAllElements[n].toString());
            if (this.fIsOptionalElement[n]) {
                System.out.print(" (optional)");
            }
            System.out.println();
            ++n;
        }
    }

    public int validateContent(QName[] qNameArray, int n, int n2) throws Exception {
        if (this.fHasOptionalContent && n2 == 0) {
            return -1;
        }
        int n3 = this.fNumElements;
        if (this.fElementsHash == null) {
            this.createElementsHash();
        }
        boolean[] blArray = new boolean[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            QName qName = qNameArray[n + n5];
            if (!this.fIsMixed || qName.localpart != -1) {
                Integer n6 = (Integer)this.fElementsHash.get(qName);
                if (n6 == null) {
                    return n5;
                }
                int n7 = n6;
                if (blArray[n7]) {
                    return n5;
                }
                blArray[n7] = true;
                if (!this.fIsOptionalElement[n7]) {
                    ++n4;
                }
            }
            ++n5;
        }
        if (n4 != this.fNumRequired) {
            return n2;
        }
        return -1;
    }

    public int validateContentSpecial(QName[] qNameArray, int n, int n2) throws Exception {
        if (this.fComparator == null) {
            return this.validateContent(qNameArray, n, n2);
        }
        if (this.fHasOptionalContent && n2 == 0) {
            return -1;
        }
        int n3 = this.fNumElements;
        boolean[] blArray = new boolean[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            block9: {
                QName qName = qNameArray[n + n5];
                if (!this.fIsMixed || qName.localpart != -1) {
                    int n6 = 0;
                    while (n6 < n3) {
                        if (this.fComparator.isEquivalentTo(qName, this.fAllElements[n6])) {
                            if (blArray[n6]) {
                                return n5;
                            }
                            blArray[n6] = true;
                            if (!this.fIsOptionalElement[n6]) {
                                ++n4;
                            }
                            break block9;
                        }
                        ++n6;
                    }
                    return n5;
                }
            }
            ++n5;
        }
        if (n4 != this.fNumRequired) {
            return n2;
        }
        return -1;
    }

    public int whatCanGoHere(boolean bl, InsertableElementsInfo insertableElementsInfo) throws Exception {
        int n;
        int n2;
        QName[] qNameArray;
        if (this.fElementsHash == null) {
            this.createElementsHash();
        }
        int n3 = this.fNumElements;
        boolean[] blArray = new boolean[n3];
        int n4 = insertableElementsInfo.curChildren.length;
        int n5 = insertableElementsInfo.insertAt;
        QName[] qNameArray2 = insertableElementsInfo.curChildren;
        int n6 = 0;
        while (n6 < n5) {
            QName qName = qNameArray2[n6];
            qNameArray = (QName[])this.fElementsHash.get(qName);
            if (qNameArray == null) {
                return n6;
            }
            n2 = qNameArray.intValue();
            if (blArray[n2]) {
                return n6;
            }
            blArray[n2] = true;
            ++n6;
        }
        insertableElementsInfo.canHoldPCData = this.fIsMixed;
        insertableElementsInfo.resultsCount = n = n3 - n5;
        if (insertableElementsInfo.results == null || insertableElementsInfo.results.length < n) {
            insertableElementsInfo.results = new boolean[n];
        }
        if (insertableElementsInfo.possibleChildren == null || insertableElementsInfo.possibleChildren.length < n) {
            qNameArray = insertableElementsInfo.possibleChildren = new QName[n];
            n2 = insertableElementsInfo.possibleChildren.length;
            int n7 = 0;
            while (n7 < n2) {
                qNameArray[n7] = new QName();
                ++n7;
            }
        }
        int n8 = 0;
        n2 = 0;
        while (n2 < n3) {
            if (!blArray[n2]) {
                insertableElementsInfo.possibleChildren[n8].setValues(this.fAllElements[n2]);
                insertableElementsInfo.results[n8] = true;
                ++n8;
            }
            ++n2;
        }
        boolean bl2 = insertableElementsInfo.isValidEOC = n == 0;
        if (n == 0) {
            return -1;
        }
        return insertableElementsInfo.childCount;
    }
}

